using System;
using System.ComponentModel;
using System.Data;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

/// <summary>
/// Treciwy opis klasy TextBoxButton
/// </summary>
namespace CustomControls
{
    public class TextBoxButton : WebControl
    {
        public event EventHandler buttonClick;
        private Button btn;
        private TextBox txBox;

        public TextBoxButton()
        {
            //
            // W tym miejscu naley doda logik konstruktora
            //
        }

        [Bindable(true),
          Category("Appearance"),
          DefaultValue("Button"),
          Description("Tekst znajdujcy si na przycisku"),
          Localizable(true)]
        public string ButtonText
        {
            get { EnsureChildControls(); return btn.Text; }
            set { EnsureChildControls(); btn.Text = value; }
        }

        [Bindable(true),
          Category("Appearance"),
          DefaultValue(""),
          Description("Tekst znajdujcy si w polu tekstowym"),
          Localizable(true)]
        public string Value
        {
            get { EnsureChildControls(); return txBox.Text; }
            set { EnsureChildControls(); txBox.Text = value; }
        }

        protected override void CreateChildControls()
        {
            txBox = new TextBox();
            Controls.Add(txBox);
            btn = new Button();
            btn.Click += new EventHandler(btn_Click);
            Controls.Add(btn);
        }

        protected override void RenderContents(HtmlTextWriter writer)
        {
            base.RenderContents(writer);
        }

        void btn_Click(object sender, EventArgs e)
        {
            if (buttonClick != null)
                buttonClick(sender, e);
        }
    }
}
